% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{summary.causalQual}
\alias{summary.causalQual}
\title{Summary Method for causalQual Objects}
\usage{
\method{summary}{causalQual}(object, ...)
}
\arguments{
\item{object}{An \code{causalQual} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Summarizes an \code{causalQual} object.
}
\description{
Summarizes an \code{causalQual} object.
}
\examples{
\donttest{## Generate synthetic data.
set.seed(1986)

data <- generate_qualitative_data_soo(1000, assignment = "observational",
                                      outcome_type = "ordered")
Y <- data$Y
D <- data$D
X <- data$X

## Estimate probabilities of shifts.
fit <- causalQual_soo(Y = Y, D = D, X = X, outcome_type = "ordered")
summary(fit)}

}
\seealso{
causalQual
}
\author{
Riccardo Di Francesco
}
