% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_prefix.R
\name{reverse_prefix}
\alias{reverse_prefix}
\title{Reverse Prefix}
\usage{
reverse_prefix(state, k)
}
\arguments{
\item{state}{Integer vector representing the current permutation state}

\item{k}{Integer, the number of leading elements to reverse}
}
\value{
Integer vector with the first k elements reversed
}
\description{
Reverses the first k elements of the state vector, analogous to the
turnstile operation in the TopSpin puzzle.
}
\examples{
# Basic example
reverse_prefix(1:10, 4)  # Returns c(4, 3, 2, 1, 5, 6, 7, 8, 9, 10)

# With variables
n <- 10
k <- 4
start_state <- 1:n
demo <- reverse_prefix(start_state, k)
print(demo)
}
