% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foursail.R
\name{r_foursail}
\alias{r_foursail}
\title{R implementation of foursail (pure R)}
\usage{
r_foursail(rho, tau, bgr, param)
}
\arguments{
\item{rho}{input leaf reflectance from 400-2500nm (can be measured or modeled)}

\item{tau}{input leaf transmittance from 400-2500nm (can be measured or modeled)}

\item{bgr}{background reflectance. Usual input is
soil reflectance spectra from 400-2500nm (can be measured or modeled)}

\item{param}{A named vector of SAIL parameter values (note: program ignores case):
 \itemize{
\item [1] = Leaf angle distribution function parameter a (LIDFa)
\item [2] = Leaf angle distribution function parameter b (LIDFb)
\item [3] = Leaf angle distribution function type (see ?lidfFun)
\item [4] = Leaf area index (LAI)
\item [5] = Hot spot effect parameter (hspot) - The foliage hot spot size
            parameter is equal to the ratio of the correlation length of leaf
            projections in the horizontal plane and the canopy height (Verhoef & Bach 2007).
\item [6] = Solar zenith angle (tts)
\item [7] = Observer zenith angle (tto)
\item [8] = Sun-sensor azimuth angle (psi)
}}
}
\value{
spectra matrixwith 4 reflectance factors and canopy transmission 
for wavelengths 400 to 2500nm:
 \itemize{
\item [1] = bi-hemispherical reflectance (rddt). White-sky albedo: the reflectance of the canopy
under diffuse illumination. The BRDF integrated over all viewing and illumination directions.  
\item [2] = hemispherical directional reflectance (rsdt). Black-sky albedo: reflectance of a surface
under direct light without a diffuse component. It is the integral of the BRDF over all viewing
directions.
\item [3] = directional hemispherical reflectance (rdot). Diffuse reflectance in the vieweing
direction. 
\item [4] = bi-directional reflectance (rsot). The ratio of reflected radiance in the viewing direction
to the incoming radiant flux in the solar direction. 
\item [5] = Canopy transmission of diffuse light through the canopy (taud).
\item [6] = transmission of direct light through the canopy (taus).
}
}
\description{
The pure R version of foursail is included in the package as an easy
way to review the code, and to check more optimized versions against.
Model originally developed by Wout Verhoef.
}
\author{
Marco D. Visser (R implementation)
}
