% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/certainty.R
\name{certainty}
\alias{certainty}
\title{Certainty equivalent computation}
\usage{
certainty(data, ival, fval, utility, wealth = 0)
}
\arguments{
\item{data}{\code{data.set} with profit for each treatment/project.
Each column is a treatment and each row a different profit
observation.}

\item{ival}{The initial value for the RAC vector to employ (scalar).}

\item{fval}{The final value for the RAC vector to employ (scalar).}

\item{utility}{Indicator of utility function: "ExpNeg" for the
Exponential Negative utility, and "Power" for the Power utility
function.}

\item{wealth}{The initial agent wealth. By default is zero.}
}
\value{
This function produces three objects: \code{CE_values}
is a table with treatment by columns and certainty values by row;
\code{RAC} is a vector with the absolute risk aversion
coefficients (ARAC) if the Power utility function was implemented,
or the relative risk aversion coefficient (RRAC) if the
Exponential Negative utility function was implemented. The length
of this vector is the same as the number of profit observations
in the original dataset; and, \code{CE_plot} is a graph using plot
function, to compare the different CEs computed.
}
\description{
Certainty equivalent computation
}
\details{
This function computes the certainty equivalent values
using profit as inputs. Works with \code{data.frames} with 3 or
more observations. Consider each column as a different treatment
or project.
}
\examples{
## Example 1. Using profit data from ceRtainty package
data(profitSWG)

# Storing CE values using Power utility function
c1 <- certainty(data    = profitSWG,
                ival    = .5,
                fval    = 4,
                utility = "Power")
c1$CE_values # Table with CE values
c1$RAC       # RAC vector used in CE computation
c1$CE_plot() # Invoking the CE plot

# To use the ExpNeg function, it is required the RRAC (ARAC/wealth)
# so we can compute the mean value among all profit in the dataset.

# Mean value among all profit value
mean(sapply(profitSWG,mean)) # 5081.844

# Storing CE values using Power utility function
c1 <- certainty(data    = profitSWG,
                ival    = .5/5082,
                fval    = 4/5082,
                utility = "ExpNeg")

c1$CE_values # Table with CE values
c1$RAC       # RAC vector used in CE computation
c1$CE_plot() # Invoking the CE plot

## Example 2. Using the example values of Hardaker et al. (2004)
dt <- data.frame(treatment=c(100,125,135,142,147,150,153,158,163,175,195))
# Storing CE values using Power utility function. Hardaker use an
# unique RAC value (0.005)
c2 <- certainty(data    = dt,
                ival    = .005,
                fval    = .005,
                utility = "Power")
# or
c2 <- certainty(data    = dt,
                ival    = .005,
                fval    = .005,
                utility = "ExpNeg")

c2$CE_values
c2$RAC
c2$CE_plot()
}
\references{
Hardaker, J.B., Richardson, J.W., Lien, G., &
Schumann, K.D. (2004). Stochastic efficiency analysis with risk
aversion bounds: a simplified approach. Australian Journal of
Agricultural and Resource Economics, 48(2), 253-270.
}
