% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rac_generator.R
\name{rac_generator}
\alias{rac_generator}
\title{RAC Generator}
\usage{
rac_generator(data, ini, fin)
}
\arguments{
\item{data}{\code{data.frame} object to weight the RAC}

\item{ini}{The initial value of the risk aversion coefficient (RAC) sequence}

\item{fin}{The final value of the risk aversion coefficient (RAC) sequence}
}
\value{
Produce a single vector of adjusted RACs.
}
\description{
RAC Generator
}
\details{
Create a vector with the adjusted relative risk aversion
coefficients to be used in the CE computation, under Power utility
function.
}
\examples{
# Example
data("profitSWG")
rac_generator(data = profitSWG$control, ini = 0.5, fin = 4.0)
}
