% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzzz.R
\name{ICsur}
\alias{ICsur}
\title{Survival probability conditional on the observed data estimation for interval censored data}
\usage{
ICsur(L, R, M, t, method, dist)
}
\arguments{
\item{L}{The numericvector of left limit of observed time. For left censored observations \code{L == 0}.}

\item{R}{The numericvector of right limit of observed time. For right censored observation \code{R == inf}.}

\item{M}{The numeric vector of marker value.}

\item{t}{A scaler time point used to calculate the the ROC curve}

\item{method}{A character indication type of modeling. This include nonparametric \code{"np"},parmetric \code{"pa"} and semiparametric \code{"sp"}.}

\item{dist}{A character incating the type of distribution for parametric model. This includes are \code{"exponential"}, \code{"weibull"}, \code{"gamma"}, \code{"lnorm"}, \code{"loglogistic"} and \code{"generalgamma"}.}
}
\value{
Return a vectors:

\code{positive    }    \code{P(T<t|L,R,M)}.

\code{negative    }     \code{P(T>t|L,R,M)}.
}
\description{
Survival probability conditional on the observed data estimation for interval censored data
}
\references{
Beyene, K. M. and El Ghouch A. (2022). Time-dependent ROC curve estimation for interval-censored data. \emph{Biometrical Journal}, 64, 1056– 1074.
}
\keyword{internal}
