## About the App

**censuspyrID Explorer** is an application for exploring harmonized and non-harmonized population pyramids from Indonesia’s population censuses (1971–2020).
Analyzing population structures over time requires consistent data. Subnational analysis in Indonesia faces additional challenges due to administrative splits of provinces.

This application (part of the `censuspyrID` package) documents population structure data from the Indonesian Population Censuses (1971–2020), harmonizes them to ensure consistency, and provides dynamic exploration features through interactive visualizations and tables.

The app supports the analysis of demographic dynamics in Indonesia at both the national and provincial levels, serving purposes in education, research, and policymaking.

---

## Acknowledgements

We would like to thank:

- **IPUMS International**, for granting access to raw sample census data from Indonesia (1971–2010).
- **Badan Pusat Statistik (Statistics Indonesia – BPS)**, for providing population statistics from the 2020 Census (*Jumlah Penduduk Menurut Wilayah, Kelompok Umur, dan Jenis Kelamin, di INDONESIA - Dataset - Sensus Penduduk 2020*).
- All developers and authors of R packages that support and are used in this application.

---

## Authors

### Ari Purwanto Sarwo Prasojo
📧 ari.prasojo18@gmail.com | arip003@brin.go.id
[![ORCID](https://img.shields.io/badge/ORCID-0000--0002--4862--5523-brightgreen?logo=orcid&logoColor=white)](https://orcid.org/0000-0002-4862-5523)

Ari is a Junior Researcher at the Research Center for Population, National Research and Innovation Agency (Badan Riset dan Inovasi Nasional – BRIN). His research focuses on quantitative and computational social demography, particularly on resilience and human development.

He holds a **Bachelor of Science in Statistics** from Brawijaya University, Malang (2016), and a **Master’s degree in Population and Labor Economics (M.E.K.K.)** from the Faculty of Economics and Business, University of Indonesia (2022).

---

### Puguh Prasetyoputra
📧 pprasetyoputra@gmail.com | pugu004@brin.go.id
[![ORCID](https://img.shields.io/badge/ORCID-0000--0001--5494--7003-brightgreen?logo=orcid&logoColor=white)](https://orcid.org/0000-0001-5494-7003)

Puguh is a Senior Researcher at the Research Center for Population, National Research and Innovation Agency (BRIN). He describes himself as an "analytical wordsmith, crafting stories with data as the pen and curiosity as the ink."

He holds a **Master of Health Economics** from The University of Queensland, Australia (2012), and a **Bachelor of Economics** from Bogor Agricultural University (2010). His research interests include Health Demography, Health Economics, Health and Development, Nutrition and Health, and Household Surveys.

---

### Nur Fitri Mustika Ayu
📧 nurfitrimustikaayu@gmail.com

Nur is a Business Statistics student at the Sepuluh Nopember Institute of Technology (ITS), currently in her sixth semester. She has a strong background in data analysis, statistical methods, and their application in business decision-making.

Her skills include quantitative analysis, big data processing, and the use of statistical tools such as R, Python, and SQL. **censuspyrID** was developed as part of her internship project at the Research Center for Population, National Research and Innovation Agency (BRIN).

---

## Citation

**APA style**:
Prasojo, A. P. S., Prasetyoputra, P., & Ayu, N. F. M. (2025). *censuspyrID: Explorer of Indonesian Population Pyramids from Harmonized and Non-Harmonized Census Data*.

**BibTeX**:
```bibtex
@misc{censuspyrid2025,
  author       = {Prasojo, Ari Purwanto Sarwo and Prasetyoputra, Puguh and Ayu, Nur Fitri Mustika},
  title        = {censuspyrID: Explorer of Indonesian Population Pyramids from Harmonized and Non-Harmonized Census Data},
  year         = {2025}
}
