% Generated by roxygen2 (4.0.2): do not edit by hand
\name{hubbell}
\alias{hubbell}
\title{Find the Hubbell centrality or the Hubbell Index}
\usage{
hubbell(graph, vids = V(graph), weights = NULL, weightfactor = 0.5)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is NULL, the default, and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute).}

\item{weightfactor}{The weight factorLogical which must be greater than 0. The defualt is 0.5.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
Hubbell centrality defined as:
\deqn{C_{h} = E + WC_{h}}{C(h) = E + WC(h)}
where \eqn{E}{E} is some exogeneous input and \eqn{W}{w} is a weight matrix derived from the adjancancy matrix \eqn{A}{A}.
}
\details{
This centrality value is defined by means of a weighted and loop allowed network. The weighted adjacency matrix \eqn{W}{w} of a network G is asymmetric and contains real-valued weights for each edge. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Hubbell_Index}{Hubbell Index}
}
\examples{
g <- barabasi.game(100)
hubbell(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}

Algorithm adapted from CentiLib (Grabler, Johannes, 2012).
}
\references{
Hubbell, Charles H. "An input-output approach to clique identification." Sociometry (1965): 377-399.

Grabler, Johannes, Dirk Koschutzki, and Falk Schreiber. "CentiLib: comprehensive analysis and exploration of network centralities." Bioinformatics 28.8 (2012): 1178-1179.
}

