\name{caller}
\alias{caller}

\title{Function to optimize the projection index}

\description{
This function provides an alternative way to optimize the projection
index, by moving along a geodesic path.}

\usage{
caller(start, index, n, bases)
}

\arguments{
  \item{start}{The Starting Projection for the optimization.}
  \item{index}{The Projection Index function. Typically generated by a
  call to the \code{pp} function.}
  \item{n}{The number of new bases to try at every stage of the
  optimization. Needs to be an array of the same length as
  \code{bases}. Typically, you either pass a constant vector, or you
  use a vector with ascending entries, so that you can try more matrices
  as the optimization proceeds.}
  \item{bases}{The number of new bases desired. Actual number generated
  may be lesser if optimization stalls.}
}

\details{
This function provides an alternative way to optimize the projection
index. It moves the index along geodesic paths between randomly
generated nearby matrices, in hopes of uncovering peaks of the index
function. By experience, one can say that it can often reveal structure
missed by Simulated Annealing optimization.
}

\value{A list of basis matrices, of length \code{bases} or shorter (if
  the optimization stalls).}

\author{
Mohit Dayal
}

\seealso{Colon}
