% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_what_if_2d.R
\name{plot.what_if_2d_explainer}
\alias{plot.what_if_2d_explainer}
\title{Plot What If 2D Explanations}
\usage{
\method{plot}{what_if_2d_explainer}(
  x,
  ...,
  split_ncol = NULL,
  add_raster = TRUE,
  add_contour = TRUE,
  add_observation = TRUE,
  bins = 3
)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with the 'what_if_2d' function}

\item{...}{currently will be ignored}

\item{split_ncol}{number of columns for the 'facet_wrap'}

\item{add_raster}{if TRUE then `geom_raster` will be added to present levels with diverging colors}

\item{add_contour}{if TRUE then `geom_contour` will be added to present contours}

\item{add_observation}{if TRUE then `geom_point` will be added to present observation that is explained}

\item{bins}{number of contours to be added}
}
\value{
a ggplot2 object
}
\description{
Function 'plot.what_if_2d_explainer' plots What-If Plots for a single prediction / observation.
}
\examples{
library("DALEX")
 \dontrun{
library("randomForest")
set.seed(59)

apartments_rf_model <- randomForest(m2.price ~ construction.year + surface + floor +
      no.rooms + district, data = apartments)

explainer_rf <- explain(apartments_rf_model,
      data = apartmentsTest[,2:6], y = apartmentsTest$m2.price)

new_apartment <- apartmentsTest[1, ]
new_apartment

wi_rf_2d <- what_if_2d(explainer_rf, observation = new_apartment)
wi_rf_2d

plot(wi_rf_2d)
plot(wi_rf_2d, add_contour = FALSE)
plot(wi_rf_2d, add_observation = FALSE)
plot(wi_rf_2d, add_raster = FALSE)

# HR data
model <- randomForest(status ~ gender + age + hours + evaluation + salary, data = HR)
pred1 <- function(m, x)   predict(m, x, type = "prob")[,1]
explainer_rf_fired <- explain(model, data = HR[,1:5],
   y = HR$status == "fired",
   predict_function = pred1, label = "fired")

new_emp <- HR[1, ]
new_emp

wi_rf_2d <- what_if_2d(explainer_rf_fired, observation = new_emp)
wi_rf_2d

plot(wi_rf_2d)
}
}
