% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{hist.duration}
\alias{hist.duration}
\title{Plot the duration}
\usage{
\method{hist}{duration}(x, breaks = NULL, ...)
}
\arguments{
\item{x}{output of \code{\link{compute_duration}} function}

\item{breaks}{number of breaks. If not given, use the Sturges rule}

\item{...}{parameters for \code{geom_histogram}}
}
\value{
a \code{ggplot} object that can be modified using \code{ggplot2} package.
}
\description{
Plot the duration
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)


# compute duration of each individual
duration <- compute_duration(d_JK)

hist(duration)

# modify the plot using ggplot2
library(ggplot2)
hist(duration) +
  labs(title = "Distribution of the duration")
}
\seealso{
\code{\link{compute_duration}}

Other Descriptive statistics: 
\code{\link{boxplot.timeSpent}()},
\code{\link{compute_duration}()},
\code{\link{compute_number_jumps}()},
\code{\link{compute_time_spent}()},
\code{\link{estimate_pt}()},
\code{\link{hist.njump}()},
\code{\link{plot.pt}()},
\code{\link{plotData}()},
\code{\link{statetable}()},
\code{\link{summary_cfd}()}
}
\author{
Quentin Grimonprez
}
\concept{Descriptive statistics}
