% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOR.R
\name{TOR}
\alias{TOR}
\title{Compute Time Outside Range}
\usage{
TOR(df, sd = 1, sr = 5)
}
\arguments{
\item{df}{Data frame read through readfile}

\item{sd}{Standard deviation indicating glycemic excursions,
default = 1}

\item{sr}{Sampling rate inverse in minutes of the CGM
(default is the Dexcom -> 5 minutes)}
}
\value{
A numeric value representing TOR
}
\description{
This function computes the time outside range (range in standard
deviations from mean, default = 1).
}
\examples{
mydatafile <- system.file("extdata", "my_data_file.csv", package = "cgmquantify")
mydata <- readfile(mydatafile)
TOR(mydata, sd = 1, sr = 5)
}
