% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R
\name{huber_mean}
\alias{huber_mean}
\title{Element-wise adaptive Huber mean estimator.}
\usage{
huber_mean(x, tau)
}
\arguments{
\item{x}{A \code{numeric} vector of observations.}

\item{tau}{A \code{numeric} scalar corresponding to the robustification parameter (larger than 0).}
}
\value{
A \code{numeric} scalar corresponding to the adaptive Huber mean estimator.
}
\description{
Computes the element-wise adaptive Huber mean estimator.
}
\examples{
set.seed(123)
y = rnorm(100)
mean(y)
huber_mean(y, 1.345)
}
\author{
Haotian Xu
}
