% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R
\name{lowertri2mat}
\alias{lowertri2mat}
\title{Transform a vector containing lower diagonal entries into a symmetric matrix of dimension p.}
\usage{
lowertri2mat(lowertri_vec, p, diag = FALSE)
}
\arguments{
\item{lowertri_vec}{A \code{numeric} vector containing lower diagonal entries.}

\item{p}{A \code{integer} scalar of dimensionality.}

\item{diag}{A \code{logic} scalar indicating if the diagonal entries are contained in lowertri_vec.}
}
\value{
A \code{numeric} p x p symmetric matrix.
}
\description{
Transform a vector containing lower diagonal entries into a symmetric matrix of dimension p.
}
\examples{
A = matrix(1:16, 4, 4)
B = lowertri2mat(A[lower.tri(A)], 4, diag = FALSE)
C = lowertri2mat(A[lower.tri(A, diag = TRUE)], 4, diag = TRUE)
}
\author{
Haotian Xu
}
