% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_loglik_methods.R
\name{anova.chantrics}
\alias{anova.chantrics}
\title{ANOVA tables: compare nested models}
\usage{
\method{anova}{chantrics}(object, ...)
}
\arguments{
\item{object}{Object of class \code{chantrics}, as returned by
\code{\link[=adj_loglik]{adj_loglik()}}.}

\item{...}{Further objects of class \code{chantrics}, as returned by
\code{\link[=adj_loglik]{adj_loglik()}}, and named parameters that should be passed to
\code{\link[chandwich:compare_models]{chandwich::compare_models()}}. The type of adjustment, out of
\code{"vertical"}, \code{"cholesky"}, \code{"spectral"}, \code{"none"}, as
specified in the parameter \code{type}, can also be specified here.}
}
\value{
An object of class \code{"anova"} inheriting from class \code{"data.frame"}.
The columns are as follows: \item{Resid.df}{The residual number of degrees
of freedom in the model.} \item{df}{The increase in residual degrees of
freedom with respect to the model in the row above.} \item{ALRTS}{The
adjusted likelihood ratio statistic.} \item{Pr(>ALRTS)}{The p-value of the
test that the model above is a "significantly better" model as the one in
the current row.}
}
\description{
\code{anova} method for \code{chantrics} objects
}
\details{
Create an analysis of adjusted deviance table for one object (sequential), or
two or more nested models that have been adjusted using the
\code{\link[=adj_loglik]{adj_loglik()}} method. It uses the adjusted likelihood ratio test
statistic (ALRTS), as described in Section 3.5 of
Chandler and Bate (2007).

Each line represents the model as given above the table, with each
line (except for the first line) showing the residual degrees of freedom of
that model, the change in degrees of freedom, the ALRTS and the
associated p-value in comparison to the model in the line above.

When a single model is specified, the function returns a sequential
analysis of deviance table, where, iteratively, one term is being removed
from the right of the full formula. This process is continued until the
"intercept only" model is left. The row names are the names of the dropped
term in comparison to the model in the line above.

If more than one model is specified, the function sorts the models by their
number of variables as returned by \code{\link[=adj_loglik]{adj_loglik()}} in
\code{attr(x, "p_current")}.

Details of the ALRT can be found in \code{\link[chandwich:compare_models]{chandwich::compare_models()}} and in
Chandler and Bate (2007).
}
\examples{

# from Introducing Chandwich.
set.seed(123)
x <- rnorm(250)
y <- rnbinom(250, mu = exp(1 + x), size = 1)
fm_pois <- glm(y ~ x + I(x^2), family = poisson)
fm_pois_adj <- adj_loglik(fm_pois)
fm_pois_small_adj <- update(fm_pois_adj, formula = . ~ . - I(x^2))
fm_pois_smallest_adj <- update(fm_pois_adj, formula = . ~ 1)

anova(fm_pois_adj, fm_pois_small_adj, fm_pois_smallest_adj)
# use different types of adjustment with type, default is "vertical"
anova(fm_pois_adj, fm_pois_small_adj, fm_pois_smallest_adj, type = "cholesky")

# sequential anova
anova(fm_pois_adj)
}
\references{
R. E. Chandler and S. Bate, Inference for clustered data using the
independence loglikelihood, Biometrika, 94 (2007), pp.
167–183. \doi{10.1093/biomet/asm015}.
}
\seealso{
\link[chandwich:compare_models]{chandwich::compare_models}: implementation of the comparison
mechanism
}
