% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address-provider-nl_NL.R
\name{AddressProvider_nl_NL}
\alias{AddressProvider_nl_NL}
\title{AddressProvider for The Netherlands}
\value{
Returns an AddressProvider object.
}
\description{
Object to create addresses for a locale.
Makes use of \link{PersonProvider} for creating street names.
}
\details{
When there is no PersonProvider for this locale, we default back to en_US.
}
\examples{
(z <- AddressProvider_nl_NL$new())
z$locale
z$postcode()
z$street_name()
z$address()
z$city()
z$province()
}
\seealso{
Other nl: 
\code{\link{ElementProvider_nl_NL}},
\code{\link{JobProvider_nl_NL}},
\code{\link{PersonProvider_nl_NL}},
\code{\link{PhoneNumberProvider_nl_BE}},
\code{\link{PhoneNumberProvider_nl_NL}},
\code{\link{SSNProvider_nl_NL}},
\code{\link{dutch-language}}

Other NL: 
\code{\link{ElementProvider_nl_NL}},
\code{\link{JobProvider_nl_NL}},
\code{\link{PersonProvider_nl_NL}},
\code{\link{PhoneNumberProvider_nl_NL}},
\code{\link{SSNProvider_nl_NL}}
}
\concept{NL}
\concept{nl}
\section{Super classes}{
\code{\link[charlatan:BareProvider]{charlatan::BareProvider}} -> \code{\link[charlatan:BaseProvider]{charlatan::BaseProvider}} -> \code{\link[charlatan:AddressProvider]{charlatan::AddressProvider}} -> \code{AddressProvider_nl_NL}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AddressProvider_nl_NL-address}{\code{AddressProvider_nl_NL$address()}}
\item \href{#method-AddressProvider_nl_NL-city}{\code{AddressProvider_nl_NL$city()}}
\item \href{#method-AddressProvider_nl_NL-street_name}{\code{AddressProvider_nl_NL$street_name()}}
\item \href{#method-AddressProvider_nl_NL-street_address}{\code{AddressProvider_nl_NL$street_address()}}
\item \href{#method-AddressProvider_nl_NL-postcode}{\code{AddressProvider_nl_NL$postcode()}}
\item \href{#method-AddressProvider_nl_NL-building_number}{\code{AddressProvider_nl_NL$building_number()}}
\item \href{#method-AddressProvider_nl_NL-province}{\code{AddressProvider_nl_NL$province()}}
\item \href{#method-AddressProvider_nl_NL-clone}{\code{AddressProvider_nl_NL$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="bothify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-bothify'><code>charlatan::BareProvider$bothify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="lexify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-lexify'><code>charlatan::BareProvider$lexify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="numerify"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-numerify'><code>charlatan::BareProvider$numerify()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit'><code>charlatan::BareProvider$random_digit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero'><code>charlatan::BareProvider$random_digit_not_zero()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_not_zero_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_not_zero_or_empty'><code>charlatan::BareProvider$random_digit_not_zero_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_digit_or_empty"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_digit_or_empty'><code>charlatan::BareProvider$random_digit_or_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element'><code>charlatan::BareProvider$random_element()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_element_prob"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_element_prob'><code>charlatan::BareProvider$random_element_prob()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_int"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_int'><code>charlatan::BareProvider$random_int()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="random_letter"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-random_letter'><code>charlatan::BareProvider$random_letter()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BareProvider" data-id="randomize_nb_elements"><a href='../../charlatan/html/BareProvider.html#method-BareProvider-randomize_nb_elements'><code>charlatan::BareProvider$randomize_nb_elements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="allowed_locales"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-allowed_locales'><code>charlatan::BaseProvider$allowed_locales()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="check_locale"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-check_locale'><code>charlatan::BaseProvider$check_locale()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="BaseProvider" data-id="print"><a href='../../charlatan/html/BaseProvider.html#method-BaseProvider-print'><code>charlatan::BaseProvider$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="AddressProvider" data-id="init_person_provider"><a href='../../charlatan/html/AddressProvider.html#method-AddressProvider-init_person_provider'><code>charlatan::AddressProvider$init_person_provider()</code></a></span></li>
<li><span class="pkg-link" data-pkg="charlatan" data-topic="AddressProvider" data-id="initialize"><a href='../../charlatan/html/AddressProvider.html#method-AddressProvider-initialize'><code>charlatan::AddressProvider$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-address}{}}}
\subsection{Method \code{address()}}{
Create an address, a combination of street, postal code and city.
The three components street, postal code and city are generated
independently, so they are not related.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-city"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-city}{}}}
\subsection{Method \code{city()}}{
Create a city
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$city()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-street_name"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-street_name}{}}}
\subsection{Method \code{street_name()}}{
Create a street name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$street_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-street_address"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-street_address}{}}}
\subsection{Method \code{street_address()}}{
Create a street address,
a combination of streetname and house indicator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$street_address()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-postcode"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-postcode}{}}}
\subsection{Method \code{postcode()}}{
Create a postal code,
does not exclude impossible postcodes in The Netherlands
(leading zero for examples) but looks good enough for most purposes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$postcode()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-building_number"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-building_number}{}}}
\subsection{Method \code{building_number()}}{
building number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$building_number()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-province"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-province}{}}}
\subsection{Method \code{province()}}{
Create a province.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$province()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AddressProvider_nl_NL-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AddressProvider_nl_NL-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AddressProvider_nl_NL$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
