% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpLocator.R
\name{pumpLocator}
\alias{pumpLocator}
\title{Locate water pump by numerical ID.}
\usage{
pumpLocator(id = 7, zoom = FALSE, vestry = FALSE, add.title = TRUE,
  highlight.segment = TRUE, latlong = FALSE)
}
\arguments{
\item{id}{Numeric or Integer. With \code{vestry = TRUE}, a whole number between 1 and 14. With \code{vestry = FALSE}, a whole number between 1 and 13. See \code{cholera::pumps.vestry} and \code{cholera::pumps} for IDs and details about specific pumps.}

\item{zoom}{Logical or Numeric. Positive numbers zoom in; negative numbers zoom out.}

\item{vestry}{Logical. \code{TRUE} for the 14 pumps from Vestry Report. \code{FALSE} for the original 13 pumps.}

\item{add.title}{Logical. Include title.}

\item{highlight.segment}{Logical. Highlight case's segment.}

\item{latlong}{Logical. Use longitude and latitude.}
}
\value{
A base R graphics plot.
}
\description{
Highlight selected water pump.
}
\examples{
pumpLocator()
pumpLocator(zoom = TRUE)
pumpLocator(14, vestry = TRUE, zoom = TRUE)
}
\seealso{
\code{\link{pumpData}}
}
