% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{datasets}
\alias{datasets}
\title{Download a database extract from \code{chronosphere} remote server}
\usage{
datasets(
  src = NULL,
  datadir = NULL,
  verbose = FALSE,
  master = FALSE,
  greetings = TRUE,
  all = FALSE
)
}
\arguments{
\item{src}{\code{character}. Source identifier. If this is set to \code{NULL}, then a simplified list of availables series will be downloaded, including all unique \code{src} and \code{ser} combinations. If \code{src} is a valid source identifier, then all accessible products (resolutions and versions) of a series are shown.}

\item{datadir}{\code{character} Directory where the downloaded files are kept. Individual entries will be looked up from the directory if this is given, and will be downloaded if they are not found. The default \code{NULL} option will download data to a temporary directory that exists only until the R session ends.}

\item{verbose}{\code{logical} Should console feedback during download be displayed?}

\item{master}{\code{logical} When \code{src} is \code{NULL}, should the function download the master records file?}

\item{greetings}{\code{logical} When the function is invoked without arguments, it displays a message to keep new users informed about different versions and resolutions (even with \code{verbose=FALSE}). This argument turns this message off on demand.}

\item{all}{\code{logical} When set to \code{FALSE} (default), only those items are shown that are available for the R environment. Set to \code{TRUE} to see all items.}
}
\value{
A \code{data.frame} class object.
}
\description{
The function will download a list of available series from the data repository
}
\details{
The function will download a single .csv file and attach it as a \code{data.frame}.
}
\examples{
# available datasets (sources and series) - proper
# index <- datasets()
# all available versions and resolutions in database 'pbdb'
# oneDat <- datasets(src="pbdb")
###################################
# local example INCOMPLETE - does not connect to the internet
ind <- datasets(
  datadir=system.file("extdata", package="chronosphere"))
# one available archive
ind <- datasets(
  src="SOM-zaffos-fragmentation",
  datadir=system.file("extdata", package="chronosphere"))
}
