% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chyper.R
\name{pvalchyper}
\alias{pvalchyper}
\title{P-values from a conditional hypergeometric distribution}
\usage{
pvalchyper(k, s, n, m, tail = "upper", verbose = T)
}
\arguments{
\item{k}{an integer or vector of integers representing the overlap size}

\item{s}{an integer representing the size of the intersecting population}

\item{n}{a vector of integers representing the sizes of each non-intersecting population}

\item{m}{a vector of integers representing the sample sizes}

\item{tail}{whether the p-value should be from the upper or lower tail (options: "upper", "lower")}

\item{verbose}{T/F should intermediate messages be printed?}
}
\value{
The probability of getting the k or more (or less if tail="lower") overlaps by chance from the conditional hypergeometric distribution specified by the parameters
}
\description{
Calculates p-values from a conditional hypergeometric distribution: the distribution of how many items are in the overlap of all samples when samples of arbitrary size are each taken without replacement from populations of arbitrary size.
}
\examples{
pvalchyper(c(1,2), 8, c(12,13,14), c(7,8,9), "upper")

}
