% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_probs_lmer.R
\name{add_probs.lmerMod}
\alias{add_probs.lmerMod}
\title{Response Probabilities for Linear Mixed Models}
\usage{
\method{add_probs}{lmerMod}(
  df,
  fit,
  q,
  name = NULL,
  yhatName = "pred",
  comparison = "<",
  type = "parametric",
  includeRanef = TRUE,
  nSims = 10000,
  log_response = FALSE,
  ...
)
}
\arguments{
\item{df}{A data frame of new data.}

\item{fit}{An object of class \code{lmerMod}.}

\item{q}{A real number. A quantile of the conditional response
distribution.}

\item{name}{\code{NULL} or a string. If \code{NULL}, probabilities
automatically will be named by \code{add_probs}, otherwise, the
probabilities will be named \code{name} in the returned data frame.}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{comparison}{A character vector of length one. Must be either
\code{"<"} or \code{">"}. If \code{comparison = "<"}, then
\eqn{Pr(Y|x < q)} is calculated for each x in the new data,
\code{df}. Otherwise, \eqn{Pr(Y|x > q)} is calculated.}

\item{type}{A string, either \code{"parametric"} or
\code{"boot"}. Determines the method used to determine the
probabilities.}

\item{includeRanef}{A logical. If \code{TRUE}, probabilities and
predictions will be calculated at the group level. If
\code{FALSE}, random effects will not be included, and
probabilities will be calculated at the population level.}

\item{nSims}{A positive integer. If \code{type = "boot"},
\code{nSims} will determine the number of bootstrap simulations to
perform.}

\item{log_response}{A logical. Set to \code{TRUE} if your model is
a log-linear mixed model: \eqn{log(Y) = X \beta + Z \gamma +
\epsilon}.}

\item{...}{Additional arguments.}
}
\value{
A dataframe, \code{df}, with predictions and probabilities
    attached.
}
\description{
This function is one of the methods of \code{add_probs}, and is
called automatically when \code{add_probs} is used on a \code{fit}
of class \code{lmerMod}.
}
\details{
It is recommended that one perform a parametric bootstrap to
determine these probabilities. To do so, use the option \code{type
= "boot"}.
}
\examples{
dat <- lme4::sleepstudy

# Fit a random intercept model
fit <- lme4::lmer(Reaction ~ Days + (1|Subject), data = lme4::sleepstudy)

# What is the probability that a new reaction time will be less
# than 300? (given the random effects).
add_probs(dat, fit, q = 300)

# What is the probability that a new reaction time will be greater
# than 300? (ignoring the random effects).
add_probs(dat, fit, q = 300, includeRanef = FALSE, comparison = ">")

}
\seealso{
\code{\link{add_ci.lmerMod}} for confidence intervals
    for \code{lmerMod} objects, \code{\link{add_pi.lmerMod}} for
    prediction intervals of \code{lmerMod} objects, and
    \code{\link{add_quantile.lmerMod}} for response quantiles of
    \code{lmerMod} objects.
}
