#' Immune modules
#'
#' @docType data
#'
#' @usage data(VP2008)
#'
#' @format An object of class GMT; see \code{read.gmt} from qusage package.
#'
#' @keywords datasets
#'
#' @references Chaussabel et al. (2008) Immunity 29:150-164
#' (\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2727981/}{PubMed})
#'
"vp2008"


#' Dice Major
#'
#' @docType data
#'
#' @usage data(dice.major)
#'
#' @format An object of class GMT; see \code{read.gmt} from qusage package.
#'
#' @keywords datasets
#'
#' @references Schmiedel et al. (2018) Immunity 175:1701-1715
#' (\doi{10.1016/j.cell.2018.10.022})
#' 
"dice.major"


#' Wikipathways
#'
#' @docType data
#'
#' @usage data(wiki)
#'
#' @format An object of class GMT; see \code{read.gmt} from qusage package.
#'
#' @keywords datasets
#'
#' @references Pico et al. (2008) PLOS Biology 
#' (\doi{10.1371/journal.pbio.0060184})
#'
"wiki"

#' Wikipathways inflammation
#'
#' @docType data
#'
#' @usage data(wiki.inf)
#'
#' @format An object of class GMT; see \code{read.gmt} from qusage package.
#'
#' @keywords datasets
#'
#' @references Pico et al. (2008) PLOS Biology 
#' (\doi{10.1371/journal.pbio.0060184})
#'
"wiki.inf"

#' PBMC scRNAseq modules
#'
#' @docType data
#'
#' @usage data(PBMC.scRNAseq)
#'
#' @format An object of class GMT; see \code{read.gmt} from qusage package.
#' 
#' @keywords datasets
#' 
#' @references Márquez et al., 2020; Nehar-Belaid et al., 2020
#' \doi{10.1038/s41590-020-0743-0}
#' \doi{10.1038/s41467-020-14396-9}
#'
#'
"PBMC.scRNAseq"

