% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vigenere.R
\name{vigenere}
\alias{vigenere}
\title{Encrypt or decrypt a Vigenere Cipher}
\usage{
vigenere(x, key, decrypt = FALSE, keep_punctuation = FALSE)
}
\arguments{
\item{x}{A vector to be encoded or decoded.}

\item{key}{A character vector of length one to use as a key}

\item{decrypt}{(Default: \code{FALSE}) The default \code{FALSE} will encrypt while
using \code{TRUE} will decrypt a given value of \code{x}.}

\item{keep_punctuation}{(Default: \code{FALSE}) The default \code{FALSE} will ignore
case and punctuation and return a lowercase result. \code{TRUE} will match the
input's case and punctuation.}
}
\value{
A character vector of length equal to x that has been transformed
}
\description{
This can be used to create (encrypt) and solve (decrypt) a
Vigenere Cipher. A Vigenere cipher uses a table of alphabetic caesar shifts
for one to twenty-six. Each letter and corresponding key value determine
the grid location to choose the obfuscated letter from.

The Vigenere Cipher Wikipedia entry provides more information on the methods
used: \url{https://en.wikipedia.org/wiki/Vigen\%C3\%A8re_cipher}
}
