% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{circ_descr}
\alias{circ_descr}
\title{A set of descriptive statistics for circular data}
\usage{
circ_descr(x, w = NULL, d = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{vector of angles}

\item{w}{weights for the values in the vector}

\item{d}{correction for the bias for data with known spacing}

\item{na.rm}{a logical value indicating whether NA values should be removed before the computation proceeds}
}
\value{
a list with descriptive statistics
\itemize{
\item mu - mean
\item sigma - standard deviation
\item skew_pewsey - skewness as defined by Pewsey
\item skew_fischer - skewness as defined by Fischer
\item rho - mean resultant length
\item skew_rel_to_zero - skewness relative to zero
}
}
\description{
A set of descriptive statistics for circular data
}
\examples{
x <- c(rnorm(50, 0, 0.5), rnorm(20, 1, 0.5))
circ_descr(x)

}
