% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_refs.R
\name{get_citation}
\alias{get_citation}
\title{Find citation based on identifier}
\usage{
get_citation(
  article_list,
  type = "doi",
  token = "WCFlpCtuJXYI1sDhZcZ8y7hHpri0SEmTnLNkeU4OEM5JTQRNXB9w"
)
}
\arguments{
\item{article_list}{List of article identifiers for which the reference
lists will be returned. Must be a list/vector of identifiers, e.g.
'"10.1186/s13750-018-0126-2" "10.1002/jrsm.1378"'.}

\item{type}{Specification of the type of input provided. The default is
'doi' (digital object identifier), but any of the following are accepted:
"pmid" (PubMed ID), "pmcid" (PubMed Central ID), "magid" (Microsoft
Academic ID), "coreid" (CORE identifier), lens_id" (The Lens.org ID),
"title" (article title; much lower specificity).}

\item{token}{An access key for the lens.org API. Tokens can be obtained by
applying for scholarly API access and creating a token once approved. See
'https://www.lens.org/lens/user/subscriptions#scholar' for further details.}
}
\value{
A dataframe containing the matching citation from Lens.org.
}
\description{
This function takes a list of articles in the form of established
identifiers (e.g. digital object identifiers) and sends a request to the
lens.org API to obtain full citation information from the Lens database for
all sought articles.
}
\examples{
\dontrun{
article_list <- c("10.1007/978-3-642-37048-9_13", "10.1111/sum.12030", 
"10.5194/bg-13-3619-2016", "10.1016/j.agee.2012.09.006")
results <- get_citation(article_list)
articles <- results$display
}
}
