% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{databases_get_schemas_tables}
\alias{databases_get_schemas_tables}
\title{Show basic table info}
\usage{
databases_get_schemas_tables(id, schema_name, table_name, credential_id = NULL)
}
\arguments{
\item{id}{integer required. The ID of the database}

\item{schema_name}{string required. The name of the schema}

\item{table_name}{string required. The name of the table}

\item{credential_id}{integer optional. If provided, schemas will be filtered based on the given credential.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the table.}
\item{databaseId}{integer, The ID of the database.}
\item{schema}{string, The name of the schema containing the table.}
\item{name}{string, Name of the table.}
\item{description}{string, The description of the table, as specified by the table owner}
\item{isView}{boolean, True if this table represents a view. False if it represents a regular table.}
\item{rowCount}{integer, The number of rows in the table.}
\item{columnCount}{integer, The number of columns in the table.}
\item{sizeMb}{number, The size of the table in megabytes.}
\item{owner}{string, The database username of the table's owner.}
\item{distkey}{string, The column used as the Amazon Redshift distkey.}
\item{sortkeys}{string, The column used as the Amazon Redshift sortkey.}
\item{refreshStatus}{string, How up-to-date the table's statistics on row counts, null counts, distinct counts, and values distributions are. One of: refreshing, stale, or current.}
\item{lastRefresh}{string, The time of the last statistics refresh.}
\item{dataUpdatedAt}{string, The last time that Civis Platform captured a change in this table.Only applicable for Redshift tables; please see the Civis help desk for more info.}
\item{schemaUpdatedAt}{string, The last time that Civis Platform captured a change to the table attributes/structure.Only applicable for Redshift tables; please see the Civis help desk for more info.}
\item{refreshId}{string, The ID of the most recent statistics refresh.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{primaryKeys}{array, The primary keys for this table.}
\item{lastModifiedKeys}{array, The columns indicating an entry's modification status for this table.}
\item{tableTags}{array, An array containing the following fields: 
\itemize{
\item id integer, Table Tag ID
\item name string, Table Tag Name
}}
\item{ontologyMapping}{list, The ontology-key to column-name mapping.  See /ontology for the list of valid ontology keys.}
\item{columns}{array, An array containing the following fields: 
\itemize{
\item name string, Name of the column.
\item civisDataType string, The generic data type of the column (ex. "string"). Since this is database-agnostic, it may be helpful when loading data to R/Python.
\item sqlType string, The database-specific SQL type of the column (ex. "varchar(30)").
\item sampleValues array, A sample of values from the column.
\item encoding string, The compression encoding for this columnSee: http://docs.aws.amazon.com/redshift/latest/dg/c_Compression_encodings.html
\item description string, The description of the column, as specified by the table owner
\item order integer, Relative position of the column in the table.
\item minValue string, Smallest value in the column.
\item maxValue string, Largest value in the column.
\item avgValue number, This parameter is deprecated.
\item stddev number, This parameter is deprecated.
\item valueDistributionPercent object, A mapping between each value in the column and the percentage of rows with that value.Only present for tables with fewer than approximately 25,000,000 rows and for columns with fewer than twenty distinct values.
\item coverageCount integer, Number of non-null values in the column.
\item nullCount integer, Number of null values in the column.
\item possibleDependentVariableTypes array, Possible dependent variable types the column may be used to model.  Null if it may not be used as a dependent variable.
\item useableAsIndependentVariable boolean, Whether the column may be used as an independent variable to train a model.
\item useableAsPrimaryKey boolean, Whether the column may be used as an primary key to identify table rows.
\item valueDistribution object, An object mapping distinct values in the column to the number of times they appear in the column
\item distinctCount integer, Number of distinct values in the column. NULL values are counted and treated as a single distinct value.
}}
\item{joins}{array, An array containing the following fields: 
\itemize{
\item id integer, 
\item leftTableId integer, 
\item leftIdentifier string, 
\item rightTableId integer, 
\item rightIdentifier string, 
\item on string, 
\item leftJoin boolean, 
\item createdAt string, 
\item updatedAt string, 
}}
\item{multipartKey}{array, }
\item{enhancements}{array, An array containing the following fields: 
\itemize{
\item type string, 
\item createdAt string, 
\item updatedAt string, 
\item joinId integer, 
}}
\item{viewDef}{string, }
\item{tableDef}{string, }
\item{outgoingTableMatches}{array, An array containing the following fields: 
\itemize{
\item sourceTableId integer, Source table
\item targetType string, Target type
\item targetId integer, Target ID
\item target object, 
\item job object, 
}}
}
\description{
Show basic table info
}
