% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revision_list.R
\name{revision_list}
\alias{revision_list}
\title{Return a list of the IDs of the site's revisions.}
\usage{
revision_list(
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{url}{Base url to use. Default: https://data.ontario.ca/ See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with
\code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with
table option uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)},
which attempts to parse data to data.frame's when possible, so the result
can vary from a vector, list or data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Return a list of the IDs of the site's revisions.
}
\examples{
\dontrun{
revision_list()
revision_list(as = "table")
revision_list(as = "json")
}
}
