% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interact_plot.R
\name{interact_plot}
\alias{interact_plot}
\title{Create interactive plot}
\usage{
interact_plot(obj, interval)
}
\arguments{
\item{obj}{A \emph{cleanTS} object.}

\item{interval}{A numeric or character, specifying the viewing interval.}
}
\value{
Does not return any value.
}
\description{
Interactive plot is similar to the animated plot, but gives the used some
control over the animation. It runs a shinyApp instead of creating a GIF.
}
\details{
The problem with an animated plot is that the user does not have any control
over the animation. There is not play or pause functionality so that the
user can observe any desired frame. This can be achieved by adding
interactivity to the plot. The \code{interact_plot()} function creates and runs a
shiny widget locally on the machine. It takes the cleanTS object and splits
the cleaned data according to the \code{interval} argument, similar to the
\verb{animate interval()} function. It then creates a shiny widget which shows the
plot for the current state and gives a slider used to change the state.
Unlike \code{animate_interval()} it provides a global report containing information
about complete data, and a state report giving information about the current
state shown in the plot.
}
\examples{
\dontrun{
   if(interactive()){
     # Using the same data used in `cleanTS()` function example.
     interact_plot(cts, interval = "1 week")
   }
}


}
