% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clickstream.r
\name{frequencies}
\alias{frequencies}
\title{Generates a Data Frame of State Frequencies for All Clickstreams in a List of Clickstreams}
\usage{
frequencies(clickstreamList)
}
\arguments{
\item{clickstreamList}{A list of clickstreams.}
}
\value{
A data frame containing state frequencies for each clickstream.
}
\description{
Generates a data frame of state frequencies for all clickstreams in a list of clickstreams.
}
\examples{

clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
cls <- as.clickstreams(clickstreams, header = TRUE)
frequencyDF <- frequencies(cls)

}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}
}
