% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate_jp}
\alias{climate_jp}
\alias{japan_climate}
\title{Climate data in Japan}
\format{
A data frame with 3768 (157 stations * 12 months * 2 periods) rows
and 14 variable:
\describe{
\item{no           }{Station no}
\item{month        }{Month}
\item{period       }{Period of observations}
\item{temperature  }{Mean temperature}
\item{precipitation}{Mean precipitation}
\item{snowfall     }{Mean snowfall}
\item{insolation   }{Mean insolation}
\item{station      }{Station name. To avoid duplication, including country name after station name. Can split by "_". Escaped by stringi::stri_escape_unicode().}
\item{country      }{Country name. Escaped by stringi::stri_escape_unicode().}
\item{latitude     }{Latitude. (degree)}
\item{NS           }{North or South.}
\item{longitude    }{Longitude. (degree)}
\item{WE           }{West or East.}
\item{altitude     }{Altitude (m)}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 3768 rows and 14 columns.
}
\usage{
climate_jp

japan_climate
}
\description{
Climate data downloaded from Japan Meteorological Agency web pages.
URLs of each station are listed in data(station_links).
https://www.data.jma.go.jp/gmd/cpd/monitor/nrmlist/
}
\examples{
library(magrittr)
library(stringi)
library(dplyr)
data(japan_climate)
japan_climate \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode)
}
\keyword{datasets}
