% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wgmean.R
\name{wgmean}
\alias{wgmean}
\title{Calculate within group means.}
\usage{
wgmean(covar, groupvar)
}
\arguments{
\item{covar}{Continuous variable for which group means will be calculated.
Please specify the dataset in which the variable is found (i.e. data$var).}

\item{groupvar}{Grouping variable within which means will be calculated.
For example, individual ID or site/plot ID. Please specify the dataset in which
the variable is found (i.e. data$var).}
}
\value{
Returns a vector containing numeric values. This can be used to
differentiate within and between group effects in a model.
See function \code{\link{wgdev}} to calculate within group deviance. 
See van de Pol and Wright 2009 for more details on the method.
}
\description{
Calculate group means of a variable. Used to test for 'between individual effects'.
See methods outlined in van de Pol and Wright 2009 for more detail.
}
\examples{
# Calculate mean temperature within years from the MassClimate dataset.  

data(MassClimate)

#Calculate year column
library(lubridate)
MassClimate$Year <- year(as.Date(MassClimate$Date, format = "\%d/\%m/\%Y"))

#Calculate mean temperature within each year
within_yr_mean <- wgmean(MassClimate$Temp, MassClimate$Year)

#Add this variable to the original dataset
MassClimate$Within_yr_mean <- within_yr_mean
             
}
\author{
Martijn van de Pol and Jonathan Wright
}
