% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{columbo}
\alias{columbo}
\title{Fictional "Columbo's Detectives" Data with Missing Values}
\format{
A tibble with 160 rows and 7 variables:
\describe{
\item{detective_id}{An integer representing the unique identifier for each detective.}
\item{group}{A factor indicating the training group (\code{"Columbo's Training"} or \code{"Control"}).}
\item{age}{An integer representing the detective's age.}
\item{gender}{A factor for the detective's gender (\code{"m"}, \code{"f"}, or \code{"d"}).}
\item{job_frustration}{A numeric score from 0-10 indicating job frustration.}
\item{time}{A factor for the measurement occasion (\code{"pre"} or \code{"post"}).}
\item{clearance}{A numeric value for the outcome, the Case Clearance Rate (in \%). This variable contains \code{NA} values.}
}
}
\source{
Simulated data where missing values in the post-intervention outcome were
introduced via a Missing At Random (MAR) mechanism. The probability of
missingness depends on observed variables (higher \code{job_frustration} and
lower post-intervention scores increase the likelihood of data being missing).
}
\usage{
columbo
}
\description{
A simulated dataset from a fictional study evaluating a special training
program by Lieutenant Columbo for detectives. This dataset is specifically
designed to demonstrate the handling of missing data. Missing values were
introduced into the post-intervention outcome using a Missing At Random
(MAR) mechanism.
}
\keyword{datasets}
