\name{beam_value_diabetes}
\alias{beam_value_diabetes}
\title{
BeAM Value for Type 2 Diabetes
}
\description{
Calculates the BeAM Value (Bedtime minus AM glucose differential). This simple metric helps determine if a patient with Type 2 Diabetes, currently treated with basal insulin, requires the addition of prandial (mealtime) insulin. A high BeAM value indicates that blood glucose is rising significantly throughout the day (post-prandial spikes), despite adequate overnight control (good AM fasting glucose).
}
\usage{
beam_value_diabetes(bedtime_glucose, am_glucose, units = "mg/dL")
}
\arguments{
  \item{bedtime_glucose}{
Numeric. Blood glucose level measured at bedtime.
}
  \item{am_glucose}{
Numeric. Fasting blood glucose level measured in the morning (pre-breakfast).
}
  \item{units}{
String. Units of measurement. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{BeAM_Value}{The calculated difference between bedtime and AM glucose.}
\item{Interpretation}{Clinical guidance. A value > 50 mg/dL (or ~2.8 mmol/L) suggests the need for prandial insulin.}
}
\references{
Zisman A, Morales F, Stewart J, et al. BeAM value: an indicator of the need to initiate and intensify prandial therapy in patients with type 2 diabetes mellitus receiving basal insulin. BMJ Open Diab Res Care. 2016;4:e000268. doi:10.1136/bmjdrc-2016-000268
}
\examples{

# Example 1: High BeAM Value (Prandial Insulin Needed)
# Bedtime 200 mg/dL, AM Fasting 110 mg/dL
# BeAM = 90 (>50)
beam_value_diabetes(200, 110)

# Example 2: Low BeAM Value (Basal Issue or Controlled)
# Bedtime 130 mg/dL, AM Fasting 120 mg/dL
# BeAM = 10
beam_value_diabetes(130, 120)
}
