\name{brain_metastasis_velocity}
\alias{brain_metastasis_velocity}
\title{
Brain Metastasis Velocity (BMV) Model
}
\description{
Calculates the Brain Metastasis Velocity (BMV) score, a prognostic metric used to predict overall survival in patients who develop new brain metastases (distant brain failure) after initial stereotactic radiosurgery (SRS). The score is defined as the cumulative number of new brain metastases developed since initial SRS divided by the time interval (in years) since that initial treatment.
}
\usage{
brain_metastasis_velocity(new_mets_count, time_interval_years)
}
\arguments{
  \item{new_mets_count}{
Numeric. The total cumulative number of new brain metastases detected since the initial SRS treatment.
}
  \item{time_interval_years}{
Numeric. The time interval between the initial SRS treatment and the appearance/diagnosis of the new brain metastases, measured in years.
}
}
\value{
A list containing:
\item{BMV_Score}{The calculated velocity (mets/year).}
\item{Risk_Class}{Risk stratification (Low < 4, Intermediate 4-13, High > 13).}
\item{Median_Overall_Survival}{Estimated median survival from the time of salvage SRS, based on the multi-institutional validation cohort.}
}
\references{
Farris M, McTyre ER, Chuong M, et al. Brain Metastasis Velocity: A Novel Prognostic Metric Predictive of Overall Survival and Freedom From Neurologic Death After Distant Brain Failure Following Upfront Radiosurgery Alone. Int J Radiat Oncol Biol Phys. 2017;98(1):131-141. doi:10.1016/j.ijrobp.2017.01.229
}
\examples{

# Example 1: Low Risk
# 2 new mets appearing 1 year after initial SRS
# BMV = 2 / 1 = 2
brain_metastasis_velocity(2, 1.0)

# Example 2: High Risk
# 8 new mets appearing 0.5 years (6 months) after initial SRS
# BMV = 8 / 0.5 = 16
brain_metastasis_velocity(8, 0.5)
}
