\name{brief_alcohol_withdrawal_scale}
\alias{brief_alcohol_withdrawal_scale}
\title{
Brief Alcohol Withdrawal Scale (BAWS)
}
\description{
Calculates the Brief Alcohol Withdrawal Scale (BAWS) score, a streamlined tool for assessing the severity of alcohol withdrawal syndrome (AWS) and guiding symptom-triggered benzodiazepine therapy. The scale evaluates 5 clinical items, each scored from 0 to 3.
}
\usage{
brief_alcohol_withdrawal_scale(tremor, sweating, agitation, orientation,
                               hallucinations)
}
\arguments{
  \item{tremor}{
Numeric (0-3).
0: No tremor.
1: Not visible, but can be felt (fingertip to fingertip).
2: Moderate, visible with arms extended.
3: Severe, visible at rest without arms extended.
}
  \item{sweating}{
Numeric (0-3). Diaphoresis.
0: No sweats.
1: Mild, barely visible / moist palms.
2: Moderate, beads of sweat visible.
3: Drenching sweats.
}
  \item{agitation}{
Numeric (0-3). Based on RASS.
0: Alert and calm (RASS 0).
1: Restless, anxious, apprehensive (RASS +1).
2: Agitated, frequent non-purposeful movement (RASS +2).
3: Very agitated, combative, violent (RASS +3 or +4).
}
  \item{orientation}{
Numeric (0-3). Confusion/Sensorium.
0: Oriented to person, place, and time.
1: Disoriented to time OR place (but not both).
2: Disoriented to time AND place.
3: Disoriented to person.
}
  \item{hallucinations}{
Numeric (0-3). Visual, auditory, or tactile.
0: None.
1: Mild (vague report, reality testing intact).
2: Moderate (more defined hallucinations).
3: Severe (obviously responding to internal stimuli, poor reality testing).
}
}
\value{
A list containing:
\item{BAWS_Score}{The calculated total score (Range 0-15).}
\item{Severity}{Classification (Mild <3, Moderate 3-5, Severe 6-8, Very Severe >8).}
\item{Management_Protocol}{Suggested benzodiazepine dosing based on the score.}
\item{Next_Step}{Recommended reassessment interval.}
}
\references{
Maldonado JR, Sher Y, Das S, et al. A prospective validation study of the prediction of alcohol withdrawal severity scale (PAWSS) in medically ill inpatients: a new scale for the prediction of complicated alcohol withdrawal syndrome. Alcohol Alcohol. 2015;50(5):509-518. (Contextual reference for withdrawal scales).
MDCalc. Brief Alcohol Withdrawal Scale (BAWS).
}
\examples{

# Example 1: Moderate Withdrawal
# Tremor (1), Sweating (1), Agitated (1), Oriented (0), No Hallucinations (0)
# Score = 3
brief_alcohol_withdrawal_scale(1, 1, 1, 0, 0)

# Example 2: Severe Withdrawal
# Tremor (2), Drenching Sweat (3), Agitated (2), Disoriented time/place (2), Mild Hallucinations (1)
# Score = 10
brief_alcohol_withdrawal_scale(2, 3, 2, 2, 1)
}
