\name{calculate_ldl}
\alias{calculate_ldl}
\title{
LDL Calculated (Friedewald Equation)
}
\description{
Calculates Low-Density Lipoprotein (LDL) cholesterol using the Friedewald equation. This formula estimates LDL based on total cholesterol, HDL cholesterol, and triglycerides. It is the standard method for reporting LDL when direct measurement is not performed, provided triglycerides are not significantly elevated.
}
\usage{
calculate_ldl(total_cholesterol, hdl_cholesterol, triglycerides, units = "mg/dL")
}
\arguments{
  \item{total_cholesterol}{
Numeric. Total Cholesterol level.
}
  \item{hdl_cholesterol}{
Numeric. High-Density Lipoprotein (HDL) Cholesterol level.
}
  \item{triglycerides}{
Numeric. Triglycerides level.
}
  \item{units}{
String. Units for all lipid inputs. Options: "mg/dL" (default) or "mmol/L".
}
}
\details{
The formula used depends on the units:
\itemize{
  \item mg/dL: LDL = Total Chol - HDL - (Triglycerides / 5)
  \item mmol/L: LDL = Total Chol - HDL - (Triglycerides / 2.2)
}
The equation is generally considered invalid if triglycerides exceed 400 mg/dL (4.5 mmol/L).
}
\value{
A list containing:
\item{LDL_Cholesterol}{The calculated LDL level.}
\item{Validity}{A warning message if the triglyceride level exceeds the validation threshold.}
}
\references{
Friedewald WT, Levy RI, Fredrickson DS. Estimation of the concentration of low-density lipoprotein cholesterol in plasma, without use of the preparative ultracentrifuge. Clin Chem. 1972;18(6):499-502.
}
\examples{

# Example 1: Standard Calculation (mg/dL)
# Total 200, HDL 50, Trigs 150
# LDL = 200 - 50 - (150/5) = 120
calculate_ldl(200, 50, 150)

# Example 2: High Triglycerides
# Total 250, HDL 40, Trigs 500
calculate_ldl(250, 40, 500)
}
