\name{calculate_tir_rosendaal}
\alias{calculate_tir_rosendaal}
\title{
Calculate Time in Target Range using Rosendaal Interpolation
}
\description{
Calculates the Time in Target Range (TIR) as a percentage using the Rosendaal linear interpolation method. This approach accurately accounts for the fractional time spent in range between two consecutive data points, which is the gold standard for continuous data streams like Continuous Glucose Monitoring (CGM).
}
\usage{
calculate_tir_rosendaal(data_vector, time_interval_minutes, target_min, target_max)
}
\arguments{
\item{data_vector}{
A numeric vector of chronologically ordered values (e.g., sensor glucose readings). Must contain at least two non-NA points for interpolation.
}
\item{time_interval_minutes}{
A single positive numeric value representing the uniform time interval (in minutes) between consecutive measurements in the \code{data_vector}.
}
\item{target_min}{
A single numeric value defining the minimum boundary of the target range (inclusive).
}
\item{target_max}{
A single numeric value defining the maximum boundary of the target range (inclusive).
}
}
\value{
A numeric value between 0 and 100 representing the calculated TIR percentage. If input validation fails, a character string with an error message is returned.
}
\details{
The Rosendaal method estimates the time in range by assuming a linear path between two adjacent measurements (\eqn{x_1} and \eqn{x_2}). The time spent out of range (below \eqn{L} or above \eqn{H}) is calculated using similar triangles, based on the magnitude of change (\eqn{|x_2 - x_1|}).

\code{NA} values are automatically omitted from \code{data_vector} before interpolation. The total observation time is based only on the intervals between valid (non-NA) points.

The core principle is:
\deqn{\text{Time in Range} = \text{Interval Time} - \text{Time Out Low} - \text{Time Out High}}
}
\examples{

#Assuming data from a 5-minute CGM interval
#Calculate TIR using Rosendaal method

cgm_data <- c(150, 140, 110, 80, 95, 120, 125, 145)
interval <- 5
min_target <- 90
max_target <- 130
calculate_tir_rosendaal(cgm_data, interval, min_target, max_target)

#Example 2: Data entirely in range

in_range_data <- c(100, 110, 120, 115, 105)
calculate_tir_rosendaal(in_range_data, 10, 90, 130) # Expected: 100

#Example 3: Error handling for invalid range

cgm_data <- c(150, 140, 110, 80, 95, 120, 125, 145)
interval <- 5
min_target <- 90
max_target <- 130
calculate_tir_rosendaal(cgm_data, interval, 130, 90)

#Example 4: Error handling for insufficient data

cgm_data <- c(150, 140, 110, 80, 95, 120, 125, 145)
interval <- 5
min_target <- 90
max_target <- 130
calculate_tir_rosendaal(c(100), interval, 90, 130)

}
\keyword{rosendaal}
\keyword{cgm}
\keyword{time in range}
\keyword{interpolation}
