\name{cart_cardiac_arrest_score}
\alias{cart_cardiac_arrest_score}
\title{
Cardiac Arrest Risk Triage (CART) Score
}
\description{
Calculates the CART score, a physiological track-and-trigger system designed to predict cardiac arrest in hospitalized patients. Unlike other early warning scores that rely on subjective assessments (like "AVPU"), CART uses weighted points for four objective vital sign and demographic variables (Respiratory Rate, Heart Rate, Diastolic BP, and Age) to identify patients at risk of deterioration.
}
\usage{
cart_cardiac_arrest_score(respiratory_rate, heart_rate, diastolic_bp, age)
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
< 21: 0 pts.
21-23: 8 pts.
24-25: 12 pts.
26-29: 15 pts.
> 29: 22 pts.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
< 110: 0 pts.
110-139: 4 pts.
> 139: 13 pts.
}
  \item{diastolic_bp}{
Numeric. Diastolic blood pressure in mmHg.
> 49: 0 pts.
40-49: 4 pts.
35-39: 6 pts.
< 35: 13 pts.
}
  \item{age}{
Numeric. Patient age in years.
< 55: 0 pts.
55-69: 4 pts.
> 69: 9 pts.
}
}
\value{
A list containing:
\item{CART_Score}{The calculated risk score (Range 0-57). Higher scores indicate a significantly higher risk of cardiac arrest or ICU transfer.}
}
\references{
Churpek MM, Yuen TC, Park SY, et al. Derivation of a cardiac arrest prediction model using ward vital signs. Crit Care Med. 2012;40(7):2102-2108. doi:10.1097/CCM.0b013e318250aa5a
}
\examples{

# Example 1: High Risk
# RR 30 (+22), HR 145 (+13), DBP 30 (+13), Age 75 (+9)
# Score = 57
cart_cardiac_arrest_score(30, 145, 30, 75)

# Example 2: Moderate Risk
# RR 22 (+8), HR 100 (0), DBP 60 (0), Age 60 (+4)
# Score = 12
cart_cardiac_arrest_score(22, 100, 60, 60)
}
