\name{crafft_screening_tool}
\alias{crafft_screening_tool}
\title{
CRAFFT Questionnaire for Adolescent Substance Abuse
}
\description{
Calculates the CRAFFT screening score to identify substance use problems in adolescents (age 12-21). The tool consists of three opening questions regarding use of alcohol, marijuana, or other drugs in the past 12 months. If any are positive, six further questions (Car, Relax, Alone, Forget, Friends, Trouble) are asked. If the opening questions are negative, only the 'Car' question is asked.
}
\usage{
crafft_screening_tool(drink_alcohol, smoke_marijuana, use_other_drugs,
                      car_driven_by_high, relax_use, alone_use, forget_things,
                      friends_family_advice, trouble_while_using)
}
\arguments{
  \item{drink_alcohol}{
Numeric (0 or 1). During the past 12 months, did you drink any alcohol (more than a few sips)? (1 = Yes).
}
  \item{smoke_marijuana}{
Numeric (0 or 1). During the past 12 months, did you smoke any marijuana or hashish? (1 = Yes).
}
  \item{use_other_drugs}{
Numeric (0 or 1). During the past 12 months, did you use anything else to get high? (1 = Yes).
}
  \item{car_driven_by_high}{
Numeric (0 or 1). Have you ever ridden in a CAR driven by someone (including yourself) who was "high" or had been using alcohol or drugs? (1 = Yes).
}
  \item{relax_use}{
Numeric (0 or 1). Do you ever use alcohol or drugs to RELAX, feel better about yourself, or fit in? (1 = Yes).
}
  \item{alone_use}{
Numeric (0 or 1). Do you ever use alcohol or drugs while you are by yourself, or ALONE? (1 = Yes).
}
  \item{forget_things}{
Numeric (0 or 1). Do you ever FORGET things you did while using alcohol or drugs? (1 = Yes).
}
  \item{friends_family_advice}{
Numeric (0 or 1). Do your family or FRIENDS ever tell you that you should cut down on your drinking or drug use? (1 = Yes).
}
  \item{trouble_while_using}{
Numeric (0 or 1). Have you ever gotten into TROUBLE while you were using alcohol or drugs? (1 = Yes).
}
}
\value{
A list containing:
\item{CRAFFT_Score}{The calculated total score (Range 0-6).}
\item{Screening_Result}{Interpretation of the score (Positive >= 2).}
\item{Recommendation}{Clinical guidance based on the result.}
}
\references{
Knight JR, Shrier LA, Bravender TD, et al. A new brief screen for adolescent substance abuse. Arch Pediatr Adolesc Med. 1999;153(6):591-596. doi:10.1001/archpedi.153.6.591
}
\examples{

# Example 1: Positive Screen
# Alcohol use (1), Car (1), Friends (1) -> Score 2
crafft_screening_tool(1, 0, 0, 1, 0, 0, 0, 1, 0)

# Example 2: Negative Screen (No substance use in past year)
# No alcohol/drugs, Car question asked (0) -> Score 0
crafft_screening_tool(0, 0, 0, 0, 0, 0, 0, 0, 0)
}
