\name{dipss_myelofibrosis}
\alias{dipss_myelofibrosis}
\title{
Dynamic International Prognostic Scoring System (DIPSS) for Myelofibrosis
}
\description{
Calculates the DIPSS score to estimate overall survival in patients with primary myelofibrosis. This dynamic scoring system can be used at any point during the disease course, unlike the IPSS which is valid only at diagnosis. The score is based on age, white blood cell count, hemoglobin, peripheral blood blasts, and constitutional symptoms.
}
\usage{
dipss_myelofibrosis(age, hemoglobin_g_dl, wbc_count_10_9_l,
                    circulating_blasts_percent, constitutional_symptoms)
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (> 65 years adds +1 point).
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. (< 10 g/dL adds +2 points).
}
  \item{wbc_count_10_9_l}{
Numeric. White Blood Cell count in 10^9/L. (> 25 x 10^9/L adds +1 point).
}
  \item{circulating_blasts_percent}{
Numeric. Percentage of circulating blasts in peripheral blood. (>= 1\% adds +1 point).
}
  \item{constitutional_symptoms}{
Numeric (0 or 1). Presence of constitutional symptoms (weight loss >10\% in 6 months, unexplained fever, or excessive sweating). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{DIPSS_Score}{The calculated total score (Range 0-6).}
\item{Risk_Category}{Risk classification (Low, Int-1, Int-2, High).}
\item{Median_Overall_Survival}{Estimated median survival time.}
}
\references{
Passamonti F, Cervantes F, Vannucchi AM, et al. A dynamic prognostic model to predict survival in primary myelofibrosis: a study by the IWG-MRT (International Working Group for Myelofibrosis Research and Treatment). Blood. 2010;115(9):1703-1708. doi:10.1182/blood-2009-09-245837
}
\examples{

# Example 1: High Risk
# Age 70 (+1), Hb 9 (+2), WBC 30 (+1), Blasts 2% (+1), Symptoms Yes (+1)
# Score = 6
dipss_myelofibrosis(70, 9.0, 30, 2, 1)

# Example 2: Intermediate-1
# Age 50 (0), Hb 11 (0), WBC 10 (0), Blasts 0 (0), Symptoms Yes (+1)
# Score = 1
dipss_myelofibrosis(50, 11.0, 10, 0, 1)
}
