\name{flamm_vbac_score}
\alias{flamm_vbac_score}
\title{
Flamm VBAC Risk Score
}
\description{
Calculates the Flamm Score to predict the probability of a successful Vaginal Birth After Cesarean (VBAC). The model incorporates maternal age, vaginal birth history, indication for the primary cesarean, and cervical status at admission.
}
\usage{
flamm_vbac_score(age, vaginal_history, reason_for_prior_c_section,
                 cervical_effacement_percent, cervical_dilation_cm)
}
\arguments{
  \item{age}{
Numeric. Maternal age in years. (<40 adds 2 points).
}
  \item{vaginal_history}{
String. History of vaginal deliveries.
"none": No vaginal deliveries (0 pts).
"before": Vaginal delivery before C-section (1 pt).
"after": Vaginal delivery after C-section (2 pts).
"both": Vaginal deliveries before and after C-section (4 pts).
}
  \item{reason_for_prior_c_section}{
String. Indication for the first C-section.
"failure_to_progress": Cephalopelvic disproportion/Failure to progress (0 pts).
"other": Breach, fetal distress, etc. (1 pt).
}
  \item{cervical_effacement_percent}{
Numeric. Cervical effacement at admission in percent (0-100).
<25%: 0 pts.
25-75%: 1 pt.
>75%: 2 pts.
}
  \item{cervical_dilation_cm}{
Numeric. Cervical dilation at admission in centimeters. (>=4 cm adds 1 point).
}
}
\value{
A list containing:
\item{Flamm_Score}{The calculated total score (Range 0-10).}
\item{Probability_Successful_VBAC}{Estimated percentage probability of successful vaginal delivery.}
}
\references{
Flamm BL, Geiger AM. Vaginal birth after cesarean delivery: an admission scoring system. Obstet Gynecol. 1997;90(6):907-910. doi:10.1016/s0029-7844(97)00531-0
}
\examples{

# Example 1: High Probability
# 30yo (+2), Prior VBAC (+2), Breech (+1), 80% effaced (+2), 5cm (+1)
# Score = 8
flamm_vbac_score(30, "after", "other", 80, 5)

# Example 2: Low Probability
# 41yo (0), No vaginal hx (0), Failure to progress (0), 0% effaced (0), 1cm (0)
# Score = 0
flamm_vbac_score(41, "none", "failure_to_progress", 0, 1)
}
