\name{heads_ed_score}
\alias{heads_ed_score}
\title{
HEADS-ED Screening Tool for Pediatric Mental Health
}
\description{
Calculates the HEADS-ED score to guide the disposition of pediatric patients presenting to the Emergency Department with mental health concerns. The tool evaluates 7 domains scored 0 (No concern), 1 (Moderate concern), or 2 (Severe concern). A total score of 8 or higher (or a score of 2 on Suicidality) typically indicates the need for immediate psychiatric consultation.
}
\usage{
heads_ed_score(home, education, activities_peers, drugs_alcohol, suicidality,
               emotions_behavior, discharge_resources)
}
\arguments{
  \item{home}{
Numeric (0-2). Status of home environment.
0: Supportive relationships.
1: Recent conflict or stress.
2: Unstable, breakdown in supervision, or crisis.
}
  \item{education}{
Numeric (0-2). School performance and attendance.
0: Attends regularly, passing.
1: Increasing absences or declining grades.
2: Not attending, suspended, or failing.
}
  \item{activities_peers}{
Numeric (0-2). Engagement in activities and peer relationships.
0: Involved in activities, good peer group.
1: Dropped activites or peer conflict.
2: Socially isolated, no positive activities.
}
  \item{drugs_alcohol}{
Numeric (0-2). Substance use.
0: No use.
1: Occasional use.
2: Chronic use interfering with function or acute intoxication.
}
  \item{suicidality}{
Numeric (0-2). Suicidal ideation or behavior.
0: No ideation.
1: Ideation without plan or intent.
2: Active plan, intent, or recent attempt.
}
  \item{emotions_behavior}{
Numeric (0-2). Observable mood and behavior.
0: Calm, cooperative.
1: Anxious, depressed, or irritable but manageable.
2: Aggressive, severely agitated, or psychotic.
}
  \item{discharge_resources}{
Numeric (0-2). Availability of follow-up supports.
0: Strong connections to community services.
1: Some barriers or limited supports.
2: No supports or caregiver burnout.
}
}
\value{
A list containing:
\item{HEADS_ED_Score}{The calculated total score (Range 0-14).}
\item{Clinical_Action}{Recommendation regarding consultation or discharge.}
}
\references{
Cappelli M, Gray C, Zemek R, et al. The HEADS-ED: A rapid mental health screening tool for pediatric patients in the emergency department. Pediatrics. 2012;130(2):e321-327. doi:10.1542/peds.2011-3798
}
\examples{

# Example 1: High Risk (Consult Required)
# Unstable home (2), Failing school (2), Suicidality with plan (2)
# Score = 10
heads_ed_score(2, 2, 0, 1, 2, 1, 2)

# Example 2: Discharge Candidate
# Mild anxiety (1), School stress (1), Supportive home (0)
# Score = 2
heads_ed_score(0, 1, 0, 0, 0, 1, 0)
}
