\name{hscore_hemophagocytic_syndrome}
\alias{hscore_hemophagocytic_syndrome}
\title{
HScore for Reactive Hemophagocytic Syndrome
}
\description{
Calculates the HScore to estimate the probability of reactive hemophagocytic syndrome (Secondary HLH) in adult patients. The score assigns points for immunosuppression history, temperature, organomegaly, cytopenias, ferritin, triglycerides/fibrinogen, AST, and bone marrow hemophagocytosis features.
}
\usage{
hscore_hemophagocytic_syndrome(immunosuppression, temp_c, hepatomegaly,
                               splenomegaly, cytopenias_count, ferritin_ng_ml,
                               triglyceride_mg_dl, fibrinogen_mg_dl,
                               ast_u_l, hemophagocytosis_marrow)
}
\arguments{
  \item{immunosuppression}{
Numeric (0 or 1). Known underlying immunosuppression (e.g., HIV, steroid use). (1 = Yes, +18 pts).
}
  \item{temp_c}{
Numeric. High body temperature in Celsius.
< 38.4: 0 pts.
38.4 - 39.4: +33 pts.
> 39.4: +49 pts.
}
  \item{hepatomegaly}{
Numeric (0 or 1). Presence of Hepatomegaly. (1 = Yes).
}
  \item{splenomegaly}{
Numeric (0 or 1). Presence of Splenomegaly. (1 = Yes).
Note: Hepatomegaly OR Splenomegaly = +23 pts. Hepatomegaly AND Splenomegaly = +38 pts.
}
  \item{cytopenias_count}{
Numeric. Number of cytopenias (Hb <= 9.2 g/dL, WBC <= 5000/mm3, Plt <= 110,000/mm3).
1 lineage: 0 pts.
2 lineages: +24 pts.
3 lineages: +34 pts.
}
  \item{ferritin_ng_ml}{
Numeric. Serum Ferritin level.
< 2000: 0 pts.
2000 - 6000: +35 pts.
> 6000: +50 pts.
}
  \item{triglyceride_mg_dl}{
Numeric. Serum Triglyceride level in mg/dL. (> 1.5 mmol/L or ~133 mg/dL counts towards metabolic criteria).
}
  \item{fibrinogen_mg_dl}{
Numeric. Serum Fibrinogen level in mg/dL. (<= 2.5 g/L or 250 mg/dL counts towards metabolic criteria).
Note: If Triglyceride > 133 mg/dL OR Fibrinogen <= 250 mg/dL, add +64 pts.
}
  \item{ast_u_l}{
Numeric. SGOT/AST level in U/L. (>= 30: +19 pts).
}
  \item{hemophagocytosis_marrow}{
Numeric (0 or 1). Hemophagocytosis features on bone marrow aspirate. (1 = Yes, +35 pts).
}
}
\value{
A list containing:
\item{HScore}{The calculated total score (Range 0-337).}
\item{HLH_Probability}{Estimated probability of having Hemophagocytic Lymphohistiocytosis (HLH). A cutoff of 169 usually yields high sensitivity and specificity.}
}
\references{
Fardet L, Galicier L, Lambotte O, et al. Development and validation of the HScore, a score for the diagnosis of reactive hemophagocytic syndrome. Arthritis Rheumatol. 2014;66(9):2613-2620. doi:10.1002/art.38690
}
\examples{

# Example 1: High Probability (HLH Likely)
# Immuno(1), Temp 40(1), Hepatosplenomegaly(2), 3 Cytopenias(3),
# Ferritin 8000(2), High Tri(1), AST 50(1), Marrow Yes(1)
hscore_hemophagocytic_syndrome(1, 40.0, 1, 1, 3, 8000, 200, 200, 50, 1)

# Example 2: Low Probability
# No Immuno, Temp 38.0, No Organomegaly, 1 Cytopenia, Ferritin 500,
# Normal Tri/Fib, AST 20, No Marrow
hscore_hemophagocytic_syndrome(0, 38.0, 0, 0, 1, 500, 100, 300, 20, 0)
}
