\name{hydroxychloroquine_dosing}
\alias{hydroxychloroquine_dosing}
\title{
Hydroxychloroquine (Plaquenil) Dosing Calculator
}
\description{
Calculates recommended hydroxychloroquine dosing based on patient weight and indication. Incorporates the American Academy of Ophthalmology (AAO) guidelines recommending a maximum daily dose of < 5 mg/kg actual body weight to minimize the risk of retinal toxicity for chronic use (Lupus/RA).
}
\usage{
hydroxychloroquine_dosing(weight_kg, indication)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient actual body weight in kilograms.
}
  \item{indication}{
String. Indication for treatment. Options: "lupus", "rheumatoid_arthritis", "malaria_prophylaxis", "malaria_treatment".
}
}
\value{
A list containing:
\item{Recommended_Dosing}{The calculated dose based on weight and indication guidelines.}
\item{Safety_Guidance}{Warnings regarding maximum safe dosage, particularly for retinal safety.}
}
\references{
Marmor MF, Kellner U, Lai TY, et al. Recommendations on Screening for Chloroquine and Hydroxychloroquine Retinopathy (2016 Revision). Ophthalmology. 2016;123(6):1386-1394. doi:10.1016/j.ophtha.2016.01.058
}
\examples{

# Example 1: Lupus Dosing (Chronic)
# 60kg patient (Max 5mg/kg = 300mg)
hydroxychloroquine_dosing(60, "lupus")

# Example 2: Malaria Treatment (Acute)
# 50kg patient
hydroxychloroquine_dosing(50, "malaria_treatment")
}
