\name{infant_scalp_score}
\alias{infant_scalp_score}
\title{
Infant Scalp Score
}
\description{
Calculates the Infant Scalp Score (Greenes & Schutzman) to stratify the risk of traumatic brain injury (TBI) in infants (<2 years) with isolated scalp hematomas. The score helps guide the decision between observation and neuroimaging (CT).
}
\usage{
infant_scalp_score(age_months, hematoma_size, hematoma_location)
}
\arguments{
  \item{age_months}{
Numeric. Patient age in months.
0-2 mo: +3 pts.
3-5 mo: +2 pts.
6-11 mo: +1 pt.
>=12 mo: 0 pts.
}
  \item{hematoma_size}{
String. Size/Character of the hematoma.
"none": No hematoma (0 pts).
"small": Barely palpable / <1 cm (1 pt).
"medium": Easily palpable / 1-3 cm (2 pts).
"large": Boggy / >3 cm (3 pts).
}
  \item{hematoma_location}{
String. Location of the hematoma.
"frontal": 0 pts.
"occipital": 1 pt.
"parietal_temporal": 2 pts.
}
}
\value{
A list containing:
\item{Infant_Scalp_Score}{The calculated risk score (Range 0-8).}
\item{Risk_Category}{"Low Risk" (Score < 4) or "High Risk" (Score >= 4).}
\item{Recommendation}{Guidance on the need for head CT.}
}
\references{
Greenes DS, Schutzman SA. Clinical indicators of intracranial injury in head-injured infants. Pediatrics. 1999;104(4 Pt 1):861-867. doi:10.1542/peds.104.4.861
}
\examples{

# Example 1: High Risk
# 2 month old (+3), Small hematoma (+1), Parietal (+2)
# Score = 6
infant_scalp_score(2, "small", "parietal_temporal")

# Example 2: Low Risk
# 9 month old (+1), Medium hematoma (+2), Frontal (0)
# Score = 3
infant_scalp_score(9, "medium", "frontal")
}
