\name{iv_drip_rate}
\alias{iv_drip_rate}
\title{
IV Drip Rate Calculator
}
\description{
Calculates the IV infusion rate in drops per minute (gtts/min). This formula is used when an electronic IV pump is unavailable, requiring manual regulation of the flow rate based on the tubing's drop factor (drops per milliliter).
}
\usage{
iv_drip_rate(volume_ml, time_min, drop_factor_gtts_ml)
}
\arguments{
  \item{volume_ml}{
Numeric. The total volume of fluid to be infused in milliliters.
}
  \item{time_min}{
Numeric. The total time for the infusion in minutes.
}
  \item{drop_factor_gtts_ml}{
Numeric. The drop factor of the IV tubing set (gtts/mL). Common macrodrip factors are 10, 15, or 20 gtts/mL; microdrip is typically 60 gtts/mL.
}
}
\value{
A list containing:
\item{Drip_Rate_gtts_min}{The calculated drip rate rounded to the nearest whole number (drops/minute).}
}
\examples{

# Example 1: 1 Liter (1000 mL) over 8 hours (480 min) with 15 gtt/mL tubing
# Rate = (1000 * 15) / 480 = 31.25 -> 31 gtts/min
iv_drip_rate(1000, 480, 15)

# Example 2: 100 mL Antibiotic over 30 min with 20 gtt/mL tubing
# Rate = (100 * 20) / 30 = 66.6 -> 67 gtts/min
iv_drip_rate(100, 30, 20)
}
