\name{lams_stroke_score}
\alias{lams_stroke_score}
\title{
Los Angeles Motor Scale (LAMS)
}
\description{
Calculates the LAMS score, a prehospital stroke severity scale designed to identify patients with Large Vessel Occlusion (LVO) who may benefit from endovascular thrombectomy. The score assesses three motor domains: Facial Droop, Arm Drift, and Grip Strength.
}
\usage{
lams_stroke_score(facial_droop, arm_drift, grip_strength)
}
\arguments{
  \item{facial_droop}{
Numeric (0 or 1).
0: Absent.
1: Present.
}
  \item{arm_drift}{
Numeric (0-2).
0: Absent.
1: Drifts down.
2: Falls rapidly.
}
  \item{grip_strength}{
Numeric (0-2).
0: Normal.
1: Weak grip.
2: No grip.
}
}
\value{
A list containing:
\item{LAMS_Score}{The calculated total score (Range 0-5).}
\item{Likelihood_LVO}{Interpretation of LVO risk (Score >= 4 typically suggests LVO).}
\item{Recommendation}{Triage guidance regarding hospital destination.}
}
\references{
Llanes JN, Kidwell CS, Starkman S, et al. The Los Angeles Motor Scale (LAMS): a new measure to characterize stroke severity in the field. Prehosp Emerg Care. 2004;8(1):46-50. doi:10.1080/312703002806
}
\examples{

# Example 1: High Risk for LVO
# Facial droop (1), Arm falls rapidly (2), No grip (2)
# Score = 5
lams_stroke_score(1, 2, 2)

# Example 2: Low Risk for LVO
# Facial droop (1), No arm drift (0), Normal grip (0)
# Score = 1
lams_stroke_score(1, 0, 0)
}
