\name{levothyroxine_dosing_calculator}
\alias{levothyroxine_dosing_calculator}
\title{
Weight-Based Levothyroxine Dose Calculator
}
\description{
Calculates the recommended starting dose of levothyroxine for adults with hypothyroidism. The calculation is based on ideal or actual body weight (typically 1.6 mcg/kg for full replacement), adjusted for age, history of coronary artery disease (CAD), and pregnancy status.
}
\usage{
levothyroxine_dosing_calculator(weight_kg, age_years, history_cad,
                                pregnant_trimester = "not_pregnant",
                                tsh_level = NA)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms. (Ideally Lean Body Weight if obese).
}
  \item{age_years}{
Numeric. Patient age in years.
}
  \item{history_cad}{
Numeric (0 or 1). History of Coronary Artery Disease. (1 = Yes).
}
  \item{pregnant_trimester}{
String. Pregnancy status. Options: "not_pregnant", "first", "second", "third".
}
  \item{tsh_level}{
Numeric (Optional). Serum TSH level to distinguish subclinical vs overt hypothyroidism.
}
}
\value{
A list containing:
\item{Recommended_Starting_Dose_mcg}{The calculated daily dose in micrograms.}
\item{Guidance}{Clinical context for the dosing recommendation.}
}
\references{
Jonklaas J, Bianco AC, Bauer AJ, et al. Guidelines for the treatment of hypothyroidism: prepared by the american thyroid association task force on thyroid hormone replacement. Thyroid. 2014;24(12):1670-1751. doi:10.1089/thy.2014.0028
}
\examples{

# Example 1: Healthy Young Adult
# 70kg, 30yo, No CAD
# Dose = 1.6 * 70 = 112 mcg
levothyroxine_dosing_calculator(70, 30, 0)

# Example 2: Elderly with CAD
# 70kg, 75yo, CAD History (1)
# Dose = 12.5 mcg (Start low)
levothyroxine_dosing_calculator(70, 75, 1)
}
