\name{maximum_allowable_blood_loss}
\alias{maximum_allowable_blood_loss}
\title{
Maximum Allowable Blood Loss (ABL) without Transfusion
}
\description{
Calculates the Maximum Allowable Blood Loss (ABL) for a patient before a red blood cell transfusion is theoretically required. The calculation estimates the patient's total blood volume (EBV) based on weight and age/sex, then uses the Bourke and Smith formula involving the initial and target hematocrit levels.
}
\usage{
maximum_allowable_blood_loss(weight_kg, initial_hct, target_hct, patient_type)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{initial_hct}{
Numeric. The patient's starting hematocrit percentage (e.g., 45).
}
  \item{target_hct}{
Numeric. The minimum acceptable hematocrit percentage (e.g., 30).
}
  \item{patient_type}{
String. The category of the patient used to estimate blood volume (mL/kg).
Options:
"premature" (95 mL/kg)
"neonate" (85 mL/kg)
"infant" (80 mL/kg)
"child" (75 mL/kg)
"adult_male" (75 mL/kg)
"adult_female" (65 mL/kg)
}
}
\value{
A list containing:
\item{Allowable_Blood_Loss_mL}{The estimated volume of blood loss permitted to reach the target hematocrit.}
\item{Estimated_Blood_Volume_mL}{The total estimated blood volume of the patient.}
}
\references{
Bourke DL, Smith TC. Estimating allowable hemodilution. Anesthesiology. 1974;41(6):609-612. doi:10.1097/00000542-197412000-00013
}
\examples{

# Example 1: Adult Male
# 80kg, Starting Hct 45, Target 30
# EBV = 80 * 75 = 6000 mL
# ABL = 6000 * (45-30) / ((45+30)/2) = 6000 * 15 / 37.5 = 2400 mL
maximum_allowable_blood_loss(80, 45, 30, "adult_male")

# Example 2: Infant
# 8kg, Starting Hct 38, Target 28
# EBV = 8 * 80 = 640 mL
# ABL = 640 * (38-28) / ((38+28)/2) = 640 * 10 / 33 = 194 mL
maximum_allowable_blood_loss(8, 38, 28, "infant")
}
