\name{mets_ir_score}
\alias{mets_ir_score}
\title{
Metabolic Score for Insulin Resistance (METS-IR)
}
\description{
Calculates the METS-IR score, a non-insulin-based index for evaluating insulin sensitivity. It combines fasting plasma glucose, triglycerides, HDL cholesterol, and BMI to estimate insulin resistance. It has been shown to be a useful screening tool for metabolic syndrome and incident type 2 diabetes.
}
\usage{
mets_ir_score(glucose_mg_dl, triglycerides_mg_dl, hdl_mg_dl, bmi)
}
\arguments{
  \item{glucose_mg_dl}{
Numeric. Fasting plasma glucose in mg/dL.
}
  \item{triglycerides_mg_dl}{
Numeric. Fasting triglycerides in mg/dL.
}
  \item{hdl_mg_dl}{
Numeric. HDL cholesterol in mg/dL.
}
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2.
}
}
\details{
The formula used is:
\deqn{METS-IR = \frac{\ln((2 \times Glucose) + Triglycerides) \times BMI}{\ln(HDL)}}
Higher scores generally indicate higher insulin resistance. While cutoffs vary by population, values > 50 are often associated with increased metabolic risk.
}
\value{
A list containing:
\item{METS_IR_Score}{The calculated METS-IR index value.}
}
\references{
Bello-Chavolla OY, Almeda-Valdes P, Gomez-Velasco D, et al. METS-IR, a novel score for evaluating insulin sensitivity, is predictive of visceral adiposity and the incident of type 2 diabetes. Eur J Endocrinol. 2018;178(5):533-544. doi:10.1530/EJE-17-0883
}
\examples{

# Example 1: Healthy Profile
# Glucose 85, Trigs 100, HDL 60, BMI 22
# Numerator: ln(170+100)*22 = ln(270)*22 = 5.6*22 = 123.2
# Denominator: ln(60) = 4.09
# Score = 30.1
mets_ir_score(85, 100, 60, 22)

# Example 2: Metabolic Syndrome Profile
# Glucose 110, Trigs 250, HDL 35, BMI 32
# Numerator: ln(220+250)*32 = ln(470)*32 = 6.15*32 = 196.8
# Denominator: ln(35) = 3.56
# Score = 55.3
mets_ir_score(110, 250, 35, 32)
}
