\name{mmrc_dyspnea_scale}
\alias{mmrc_dyspnea_scale}
\title{
Modified Medical Research Council (mMRC) Dyspnea Scale
}
\description{
Retrieves the description for the Modified Medical Research Council (mMRC) Dyspnea Scale grade. This scale quantifies the disability associated with breathlessness in patients with respiratory diseases, particularly COPD, by assessing the level of activity that provokes dyspnea.
}
\usage{
mmrc_dyspnea_scale(grade)
}
\arguments{
  \item{grade}{
Numeric (0-4). The patient's selected grade.
0: Breathless only with strenuous exercise.
1: Short of breath when hurrying or walking up a slight hill.
2: Walks slower than contemporaries or stops for breath when walking at own pace.
3: Stops for breath after 100m or a few minutes.
4: Too breathless to leave house or breathless when dressing.
}
}
\value{
A list containing:
\item{mMRC_Grade}{The input grade.}
\item{Description}{The clinical description of the patient's functional limitation due to dyspnea.}
}
\references{
Fletcher CM. The clinical diagnosis of pulmonary emphysema; an experimental study. Proc R Soc Med. 1952;45(9):577-584.
Bestall JC, Paul EA, Garrod R, Garnham R, Jones PW, Wedzicha JA. Usefulness of the Medical Research Council (MRC) dyspnoea scale as a measure of disability in patients with chronic obstructive pulmonary disease. Thorax. 1999;54(7):581-586. doi:10.1136/thx.54.7.581
}
\examples{

# Example 1: Grade 2 (Moderate impairment)
mmrc_dyspnea_scale(2)

# Example 2: Grade 4 (Severe impairment)
mmrc_dyspnea_scale(4)
}
